/*
 * Decompiled with CFR 0.152.
 */
package owl.translations;

import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import owl.automaton.Automaton;
import owl.automaton.AutomatonUtil;
import owl.automaton.Views;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.CoBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.acceptance.RabinAcceptance;
import owl.factories.EquivalenceClassFactory;
import owl.factories.Factories;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.Formula;
import owl.ltl.LabelledFormula;
import owl.ltl.SyntacticFragment;
import owl.ltl.SyntacticFragments;
import owl.ltl.XOperator;
import owl.run.Environment;
import owl.translations.canonical.BreakpointState;
import owl.translations.canonical.DeterministicConstructions;
import owl.translations.canonical.GenericConstructions;
import owl.translations.canonical.RoundRobinState;
import owl.translations.delag.DelagBuilder;
import owl.translations.ltl2dpa.LTL2DPAFunction;
import owl.translations.ltl2dra.SymmetricDRAConstruction;

public final class LTL2DAFunction
implements Function<LabelledFormula, Automaton<?, ?>> {
    private final Environment environment;
    private final EnumSet<Constructions> allowedConstructions;
    private final Function<LabelledFormula, ? extends Automaton<?, ?>> fallback;

    public LTL2DAFunction(Environment environment) {
        this(environment, false, EnumSet.allOf(Constructions.class));
    }

    public LTL2DAFunction(Environment environment, boolean onTheFly, EnumSet<Constructions> allowedConstructions) {
        this.allowedConstructions = EnumSet.copyOf(allowedConstructions);
        this.environment = environment;
        if (this.allowedConstructions.contains((Object)Constructions.EMERSON_LEI)) {
            this.fallback = new DelagBuilder(environment);
        } else if (this.allowedConstructions.contains((Object)Constructions.GENERALIZED_RABIN)) {
            this.fallback = SymmetricDRAConstruction.of(environment, RabinAcceptance.class, !onTheFly);
        } else if (this.allowedConstructions.contains((Object)Constructions.RABIN)) {
            this.fallback = SymmetricDRAConstruction.of(environment, GeneralizedRabinAcceptance.class, !onTheFly);
        } else if (this.allowedConstructions.contains((Object)Constructions.PARITY)) {
            EnumSet<LTL2DPAFunction.Configuration> configuration = onTheFly ? EnumSet.of(LTL2DPAFunction.Configuration.COMPLEMENT_CONSTRUCTION_HEURISTIC) : EnumSet.copyOf(LTL2DPAFunction.RECOMMENDED_ASYMMETRIC_CONFIG);
            this.fallback = new LTL2DPAFunction(environment, configuration);
        } else {
            this.fallback = x -> {
                throw new IllegalArgumentException("All allowed constructions exhausted.");
            };
        }
    }

    @Override
    public Automaton<?, ?> apply(LabelledFormula formula) {
        Set<Formula> formulas;
        if (this.allowedConstructions.contains((Object)Constructions.SAFETY) && SyntacticFragment.SAFETY.contains(formula)) {
            return LTL2DAFunction.safety(this.environment, formula);
        }
        if (this.allowedConstructions.contains((Object)Constructions.CO_SAFETY) && SyntacticFragment.CO_SAFETY.contains(formula)) {
            return LTL2DAFunction.coSafety(this.environment, formula);
        }
        if (formula.formula() instanceof XOperator) {
            int xCount = 0;
            Formula unwrappedFormula = formula.formula();
            while (unwrappedFormula instanceof XOperator) {
                ++xCount;
                unwrappedFormula = ((XOperator)unwrappedFormula).operand;
            }
            return GenericConstructions.delay(this.apply(formula.wrap(unwrappedFormula)), xCount);
        }
        if (this.allowedConstructions.contains((Object)Constructions.BUCHI) || this.allowedConstructions.contains((Object)Constructions.GENERALIZED_BUCHI)) {
            Set<Formula> set = formulas = formula.formula() instanceof Conjunction ? formula.formula().children() : Set.of(formula.formula());
            if (formulas.stream().allMatch(SyntacticFragments::isGfCoSafety)) {
                return LTL2DAFunction.gfCoSafety(this.environment, formula, this.allowedConstructions.contains((Object)Constructions.GENERALIZED_BUCHI));
            }
            if (SyntacticFragments.isGCoSafety(formula.formula())) {
                return LTL2DAFunction.gCoSafety(this.environment, formula);
            }
        }
        if (this.allowedConstructions.contains((Object)Constructions.CO_BUCHI)) {
            Set<Formula> set = formulas = formula.formula() instanceof Disjunction ? formula.formula().children() : Set.of(formula.formula());
            if (formulas.size() > 1 && formulas.stream().allMatch(SyntacticFragments::isFgSafety)) {
                return LTL2DAFunction.fgSafetyInterleaved(this.environment, formula);
            }
            if (SyntacticFragments.isFgSafety(formula.formula())) {
                return LTL2DAFunction.fgSafety(this.environment, formula);
            }
            if (SyntacticFragments.isFSafety(formula.formula())) {
                return LTL2DAFunction.fSafety(this.environment, formula);
            }
        }
        return this.fallback.apply(formula);
    }

    public static Automaton<EquivalenceClass, AllAcceptance> safety(Environment environment, LabelledFormula formula) {
        Factories factories = environment.factorySupplier().getFactories(formula.variables(), false);
        return new DeterministicConstructions.Safety(factories, true, formula.formula());
    }

    public static Automaton<EquivalenceClass, BuchiAcceptance> coSafety(Environment environment, LabelledFormula formula) {
        Factories factories = environment.factorySupplier().getFactories(formula.variables(), false);
        return new DeterministicConstructions.CoSafety(factories, true, formula.formula());
    }

    public static Automaton<RoundRobinState<EquivalenceClass>, GeneralizedBuchiAcceptance> gfCoSafety(Environment environment, LabelledFormula formula, boolean generalized) {
        Factories factories = environment.factorySupplier().getFactories(formula.variables(), false);
        Set<Formula> formulas = formula.formula() instanceof Conjunction ? formula.formula().children() : Set.of(formula.formula());
        return new DeterministicConstructions.GfCoSafety(factories, true, formulas, generalized);
    }

    public static Automaton<EquivalenceClass, CoBuchiAcceptance> fgSafety(Environment environment, LabelledFormula formula) {
        Factories factories = environment.factorySupplier().getFactories(formula.variables(), false);
        return new DeterministicConstructions.FgSafety(factories, true, formula.formula());
    }

    public static Automaton<RoundRobinState<EquivalenceClass>, CoBuchiAcceptance> fgSafetyInterleaved(Environment environment, LabelledFormula formula) {
        Automaton<RoundRobinState<EquivalenceClass>, GeneralizedBuchiAcceptance> automaton = LTL2DAFunction.gfCoSafety(environment, formula.not(), false);
        EquivalenceClassFactory factory = automaton.onlyInitialState().state().factory();
        Automaton<RoundRobinState<EquivalenceClass>, OmegaAcceptance> complementAutomaton = Views.complement(automaton, RoundRobinState.of(0, factory.getFalse()));
        return AutomatonUtil.cast(complementAutomaton, CoBuchiAcceptance.class);
    }

    public static Automaton<BreakpointState<EquivalenceClass>, BuchiAcceptance> gCoSafety(Environment environment, LabelledFormula formula) {
        Factories factories = environment.factorySupplier().getFactories(formula.variables(), false);
        return new DeterministicConstructions.GCoSafety(factories, true, formula.formula());
    }

    public static Automaton<BreakpointState<EquivalenceClass>, CoBuchiAcceptance> fSafety(Environment environment, LabelledFormula formula) {
        Automaton<BreakpointState<EquivalenceClass>, BuchiAcceptance> automaton = LTL2DAFunction.gCoSafety(environment, formula.not());
        EquivalenceClassFactory factory = automaton.onlyInitialState().current().factory();
        Automaton<BreakpointState<EquivalenceClass>, OmegaAcceptance> complementAutomaton = Views.complement(automaton, BreakpointState.of(factory.getFalse(), factory.getFalse()));
        return AutomatonUtil.cast(complementAutomaton, CoBuchiAcceptance.class);
    }

    public static enum Constructions {
        SAFETY,
        CO_SAFETY,
        BUCHI,
        GENERALIZED_BUCHI,
        CO_BUCHI,
        PARITY,
        RABIN,
        GENERALIZED_RABIN,
        EMERSON_LEI;

    }
}

