/*
 * Decompiled with CFR 0.152.
 */
package jhoafparser.transformations;

import java.util.ArrayList;
import java.util.List;
import jhoafparser.ast.AtomLabel;
import jhoafparser.ast.BooleanExpression;
import jhoafparser.consumer.HOAConsumer;
import jhoafparser.consumer.HOAConsumerException;
import jhoafparser.consumer.HOAConsumerStore;
import jhoafparser.consumer.HOAIntermediate;
import jhoafparser.storage.StoredAutomaton;
import jhoafparser.storage.StoredAutomatonManipulator;

public class ToTransitionAcceptance
extends HOAIntermediate {
    private List<Integer> currentStateSignature;

    public ToTransitionAcceptance(HOAConsumer next) {
        super(next);
    }

    public static StoredAutomatonManipulator getStoredAutomatonManipulator() {
        return new StoredAutomatonManipulator(){

            @Override
            public StoredAutomaton manipulate(StoredAutomaton aut) throws HOAConsumerException {
                HOAConsumerStore storeTransformed = new HOAConsumerStore();
                ToTransitionAcceptance transform = new ToTransitionAcceptance(storeTransformed);
                aut.feedToConsumer(transform);
                return storeTransformed.getStoredAutomaton();
            }
        };
    }

    @Override
    public void addProperties(List<String> properties) throws HOAConsumerException {
        ArrayList<String> filtered = new ArrayList<String>();
        for (String property : properties) {
            if (property.equals("state-acc") || property.equals("trans-acc")) continue;
            filtered.add(property);
        }
        this.next.addProperties(filtered);
    }

    @Override
    public void notifyBodyStart() throws HOAConsumerException {
        ArrayList<String> property = new ArrayList<String>(1);
        property.add("trans-acc");
        this.next.addProperties(property);
    }

    @Override
    public void addState(int id, String info, BooleanExpression<AtomLabel> labelExpr, List<Integer> accSignature) throws HOAConsumerException {
        this.currentStateSignature = accSignature;
        this.next.addState(id, info, labelExpr, null);
    }

    @Override
    public void addEdgeImplicit(int stateId, List<Integer> conjSuccessors, List<Integer> accSignature) throws HOAConsumerException {
        List<Integer> transAccSignature;
        if (accSignature != null && this.currentStateSignature != null) {
            transAccSignature = new ArrayList<Integer>(accSignature);
            transAccSignature.addAll(accSignature);
        } else {
            transAccSignature = accSignature != null ? accSignature : this.currentStateSignature;
        }
        this.next.addEdgeImplicit(stateId, conjSuccessors, transAccSignature);
    }

    @Override
    public void addEdgeWithLabel(int stateId, BooleanExpression<AtomLabel> labelExpr, List<Integer> conjSuccessors, List<Integer> accSignature) throws HOAConsumerException {
        List<Integer> transAccSignature;
        if (accSignature != null && this.currentStateSignature != null) {
            transAccSignature = new ArrayList<Integer>(accSignature);
            transAccSignature.addAll(accSignature);
        } else {
            transAccSignature = accSignature != null ? accSignature : this.currentStateSignature;
        }
        this.next.addEdgeWithLabel(stateId, labelExpr, conjSuccessors, transAccSignature);
    }
}

