/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import java.util.Objects;
import java.util.Set;
import owl.ltl.Formula;

public abstract class BinaryModalOperator
extends Formula.ModalOperator {
    public final Formula left;
    public final Formula right;

    BinaryModalOperator(Class<? extends BinaryModalOperator> clazz, Formula leftOperand, Formula rightOperand) {
        super(Objects.hash(clazz, leftOperand, rightOperand));
        this.left = leftOperand;
        this.right = rightOperand;
    }

    @Override
    public Set<Formula> children() {
        return Set.of(this.left, this.right);
    }

    @Override
    public final boolean isPureEventual() {
        return false;
    }

    @Override
    public final boolean isPureUniversal() {
        return false;
    }

    public abstract String operatorSymbol();

    public final String toString() {
        return String.format("(%s%s%s)", this.left, this.operatorSymbol(), this.right);
    }

    @Override
    protected final int compareToImpl(Formula o) {
        assert (this.getClass() == o.getClass());
        BinaryModalOperator that = (BinaryModalOperator)o;
        int comparison = this.left.compareTo(that.left);
        return comparison == 0 ? this.right.compareTo(that.right) : comparison;
    }

    @Override
    protected final boolean equalsImpl(Formula o) {
        assert (this.getClass() == o.getClass());
        BinaryModalOperator that = (BinaryModalOperator)o;
        return this.left.equals(that.left) && this.right.equals(that.right);
    }
}

