/*
 * Decompiled with CFR 0.152.
 */
package owl.game.algorithms;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.edge.Edge;
import owl.game.Game;
import owl.game.GameViews;
import owl.run.modules.Transformer;
import owl.run.modules.Transformers;

public final class ParityGameSolver {
    public static final Transformer ZIELONKA_SOLVER = Transformers.fromFunction(Game.class, x -> {
        WinningRegions winning = ParityGameSolver.recursiveZielonka(x);
        return winning.player2.contains(x.onlyInitialState()) ? "The specification is REALISABLE" : "The specification is UNREALISABLE";
    });

    private ParityGameSolver() {
    }

    private static <S> WinningRegions<S> recursiveZielonka(Game<S, ParityAcceptance> game) {
        Game.Owner ourHorse;
        Set states = game.states();
        ParityAcceptance acceptance = (ParityAcceptance)game.acceptance();
        AtomicInteger minimalColour = new AtomicInteger(acceptance.acceptanceSets());
        for (Object state : states) {
            game.edges(state).forEach(edge -> minimalColour.getAndUpdate(c -> Math.min(c, edge.smallestAcceptanceSet())));
        }
        int theMinimalColour = minimalColour.get();
        Game.Owner owner = ourHorse = acceptance.isAccepting(theMinimalColour) ? Game.Owner.PLAYER_2 : Game.Owner.PLAYER_1;
        if (theMinimalColour == acceptance.acceptanceSets()) {
            return new WinningRegions(states, ourHorse);
        }
        Predicate<Edge> hasMinCol = y -> y.smallestAcceptanceSet() == theMinimalColour;
        Set winningStates = Sets.filter(states, x -> {
            if (game.getOwner(x) != Game.Owner.PLAYER_2) {
                return false;
            }
            if (Game.Owner.PLAYER_2 == ourHorse) {
                return game.edges(x).stream().anyMatch(hasMinCol);
            }
            return game.edges(x).stream().allMatch(hasMinCol);
        });
        assert (winningStates.stream().allMatch(x -> game.getOwner(x) == Game.Owner.PLAYER_2));
        Sets.SetView losingSet = Sets.difference(states, game.getAttractorFixpoint(winningStates, ourHorse));
        Game<S, ParityAcceptance> subGame = GameViews.filter(game, losingSet, hasMinCol.negate());
        WinningRegions<S> subWinning = ParityGameSolver.recursiveZielonka(subGame);
        if (subWinning.winningRegion(ourHorse).containsAll(subGame.states())) {
            return new WinningRegions(states, ourHorse);
        }
        Set<S> opponentAttractor = game.getAttractorFixpoint(subWinning.winningRegion(ourHorse.opponent()), ourHorse.opponent());
        Sets.SetView difference = Sets.difference(states, opponentAttractor);
        WinningRegions<S> newSubWinning = ParityGameSolver.recursiveZielonka(GameViews.filter(game, difference));
        newSubWinning.addAll(opponentAttractor, ourHorse.opponent());
        return newSubWinning;
    }

    public static <S> boolean zielonkaRealizability(Game<S, ParityAcceptance> game) {
        return ParityGameSolver.recursiveZielonka(GameViews.replaceInitialStates(game, game.states())).player2.contains(game.onlyInitialState());
    }

    private static final class WinningRegions<S> {
        final Set<S> player1;
        final Set<S> player2;

        WinningRegions(Set<S> s, Game.Owner o) {
            if (Game.Owner.PLAYER_1 == o) {
                this.player1 = new HashSet<S>(s);
                this.player2 = new HashSet<S>();
            } else {
                this.player1 = new HashSet<S>();
                this.player2 = new HashSet<S>(s);
            }
        }

        void addAll(Set<S> s, Game.Owner o) {
            if (Game.Owner.PLAYER_1 == o) {
                this.player1.addAll(s);
            } else {
                this.player2.addAll(s);
            }
        }

        Set<S> winningRegion(Game.Owner o) {
            return Game.Owner.PLAYER_1 == o ? this.player1 : this.player2;
        }
    }
}

