/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import java.util.BitSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import owl.automaton.AbstractImplicitAutomaton;
import owl.automaton.EdgeMapAutomatonMixin;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.edge.Edge;
import owl.collections.ValuationSet;
import owl.factories.ValuationSetFactory;

class ImplicitNonDeterministicEdgeMapAutomaton<S, A extends OmegaAcceptance>
extends AbstractImplicitAutomaton<S, A>
implements EdgeMapAutomatonMixin<S, A> {
    @Nullable
    private final BiFunction<S, BitSet, Set<Edge<S>>> edgesFunction;
    private final Function<S, ? extends Map<Edge<S>, ValuationSet>> edgeMapFunction;

    ImplicitNonDeterministicEdgeMapAutomaton(ValuationSetFactory factory, Collection<S> initialStates, A acceptance, @Nullable BiFunction<S, BitSet, Set<Edge<S>>> edgesFunction, Function<S, ? extends Map<Edge<S>, ValuationSet>> edgeMapFunction) {
        super(factory, initialStates, acceptance);
        this.edgesFunction = edgesFunction;
        this.edgeMapFunction = edgeMapFunction;
    }

    @Override
    public Set<Edge<S>> edges(S state, BitSet valuation) {
        assert (this.cache() == null || this.cache().contains(state));
        if (this.edgesFunction != null) {
            return this.edgesFunction.apply(state, valuation);
        }
        return EdgeMapAutomatonMixin.super.edges(state, valuation);
    }

    @Override
    public Map<Edge<S>, ValuationSet> edgeMap(S state) {
        assert (this.cache() == null || this.cache().contains(state));
        return this.edgeMapFunction.apply(state);
    }
}

