/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.safra;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;
import owl.translations.safra.Tree;

@ParametersAreNonnullByDefault
@Generated(from="Tree", generator="Immutables")
@CheckReturnValue
@Immutable
final class TreeTuple<L>
extends Tree<L> {
    private final L label;
    private final ImmutableList<Tree<L>> children;
    private final transient int hashCode;

    private TreeTuple(L label, Iterable<? extends Tree<L>> children) {
        this.label = Objects.requireNonNull(label, "label");
        this.children = ImmutableList.copyOf(children);
        this.hashCode = this.computeHashCode();
    }

    @Override
    L label() {
        return this.label;
    }

    @Override
    ImmutableList<Tree<L>> children() {
        return this.children;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof TreeTuple && this.equalTo((TreeTuple)another);
    }

    private boolean equalTo(TreeTuple<?> another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.label.equals(another.label) && this.children.equals(another.children);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.label.hashCode();
        h += (h << 5) + this.children.hashCode();
        return h;
    }

    public static <L> TreeTuple<L> create(L label, List<Tree<L>> children) {
        return TreeTuple.create(label, children);
    }

    public static <L> TreeTuple<L> create(L label, Iterable<? extends Tree<L>> children) {
        return new TreeTuple<L>(label, children);
    }
}

