/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.safra;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import de.tum.in.naturals.bitset.BitSets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import owl.automaton.Automaton;
import owl.automaton.AutomatonFactory;
import owl.automaton.AutomatonUtil;
import owl.automaton.Views;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.RabinAcceptance;
import owl.automaton.edge.Edge;
import owl.automaton.edge.Edges;
import owl.collections.Collections3;
import owl.run.modules.ImmutableTransformerParser;
import owl.run.modules.OwlModuleParser;
import owl.translations.safra.LabelTuple;
import owl.translations.safra.Tree;
import owl.util.annotation.Tuple;

public final class SafraBuilder {
    private static final Logger logger = Logger.getLogger(SafraBuilder.class.getName());
    public static final OwlModuleParser.TransformerParser CLI = ImmutableTransformerParser.builder().key("safra").description("Translates NBA to DRA using Safra's construction").parser(settings -> environment -> (input, context) -> {
        Automaton nba;
        Preconditions.checkArgument((boolean)(input instanceof Automaton));
        Automaton automaton = (Automaton)input;
        if (automaton.acceptance() instanceof AllAcceptance) {
            nba = Views.viewAs(AutomatonUtil.cast(automaton, AllAcceptance.class), BuchiAcceptance.class);
        } else if (automaton.acceptance() instanceof BuchiAcceptance) {
            nba = AutomatonUtil.cast(automaton, BuchiAcceptance.class);
        } else {
            throw new UnsupportedOperationException(automaton.acceptance() + " is unsupported.");
        }
        return SafraBuilder.build(nba);
    }).build();

    private SafraBuilder() {
    }

    public static <S> Automaton<Tree<Label<S>>, RabinAcceptance> build(Automaton<S, BuchiAcceptance> nba) {
        int nbaSize = nba.size();
        int pairCount = nbaSize * 2;
        RabinAcceptance acceptance = RabinAcceptance.of(pairCount);
        Tree<Label<S>> initialState = Tree.of(Label.of(Set.copyOf(nba.initialStates()), 0));
        BiFunction<Tree, BitSet, Edge> successor = (tree, valuation) -> {
            BitSet usedIndices = new BitSet(nbaSize);
            tree.forEach(node -> usedIndices.set(node.index()));
            BitSet edgeAcceptance = new BitSet(nbaSize);
            Tree<Label> successorTree = tree.map((father, children) -> {
                Set fatherEdges = father.states().stream().flatMap(state -> nba.edges((Object)state, (BitSet)valuation).stream()).collect(Collectors.toSet());
                if (fatherEdges.isEmpty()) {
                    return Tree.of(father.with(Set.of()));
                }
                Label newFather = father.with(Edges.successors(fatherEdges));
                Set newChildStates = fatherEdges.stream().filter(edge -> edge.inSet(0)).map(Edge::successor).collect(Collectors.toUnmodifiableSet());
                int index = usedIndices.nextClearBit(0);
                usedIndices.set(index);
                return Tree.of(newFather, Collections3.append(children, Tree.of(Label.of(newChildStates, index))));
            }).map((father, children) -> {
                HashSet olderStates = new HashSet();
                ArrayList prunedChildren = new ArrayList(children.size());
                for (Tree child : children) {
                    Label prunedLabel = ((Label)child.label()).without(olderStates);
                    if (prunedLabel.states().isEmpty()) {
                        edgeAcceptance.set(acceptance.pairs().get(prunedLabel.index()).finSet());
                        usedIndices.clear(prunedLabel.index());
                        continue;
                    }
                    prunedChildren.add(child.map((subNode, subChildren) -> Tree.of(subNode.without(olderStates), subChildren)));
                    olderStates.addAll(prunedLabel.states());
                }
                return Tree.of(father, prunedChildren);
            }).map((father, children) -> {
                List nonEmptyChildren = children.stream().filter(child -> !((Label)child.label()).states().isEmpty()).collect(Collectors.toUnmodifiableList());
                if (nonEmptyChildren.isEmpty()) {
                    return Tree.of(father);
                }
                Set childStates = nonEmptyChildren.stream().map(Tree::label).map(Label::states).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
                if (childStates.equals(father.states())) {
                    edgeAcceptance.set(acceptance.pairs().get(father.index()).infSet());
                    children.forEach(child -> child.forEach(node -> usedIndices.clear(node.index())));
                    return Tree.of(father);
                }
                return Tree.of(father, nonEmptyChildren);
            });
            usedIndices.flip(0, nbaSize);
            BitSets.forEach((BitSet)usedIndices, index -> edgeAcceptance.set(acceptance.pairs().get(index).finSet()));
            logger.log(Level.FINEST, "{0} + {1} -> {2} @ {3}", new Object[]{tree, valuation, successorTree, edgeAcceptance});
            return Edge.of(successorTree, edgeAcceptance);
        };
        return AutomatonFactory.create(nba.factory(), initialState, acceptance, successor);
    }

    @Tuple
    @Value.Immutable
    public static abstract class Label<S> {
        abstract Set<S> states();

        abstract int index();

        static <S> Label<S> of(Collection<S> states, int index) {
            assert (index >= 0);
            return LabelTuple.create(states, index);
        }

        Label<S> without(Set<S> states) {
            return Label.of(Sets.difference(this.states(), states), this.index());
        }

        Label<S> with(Collection<S> states) {
            return Label.of(states, this.index());
        }

        public String toString() {
            return this.states().stream().map(Object::toString).sorted().collect(Collectors.toSet()) + ":" + this.index();
        }
    }
}

