/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ltl2ldba.breakpoint;

import java.util.BitSet;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonFactory;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.edge.Edge;
import owl.collections.Collections3;
import owl.factories.Factories;
import owl.ltl.EquivalenceClass;
import owl.ltl.SyntacticFragment;
import owl.translations.ltl2ldba.AbstractAcceptingComponentBuilder;
import owl.translations.ltl2ldba.LTL2LDBAFunction;
import owl.translations.ltl2ldba.breakpoint.DegeneralizedBreakpointState;
import owl.translations.ltl2ldba.breakpoint.GObligations;

public final class DegeneralizedAcceptingComponentBuilder
extends AbstractAcceptingComponentBuilder<DegeneralizedBreakpointState, BuchiAcceptance, GObligations> {
    public DegeneralizedAcceptingComponentBuilder(Factories factories, Set<LTL2LDBAFunction.Configuration> optimisations) {
        super(optimisations, factories);
    }

    @Override
    public MutableAutomaton<DegeneralizedBreakpointState, BuchiAcceptance> build() {
        return MutableAutomatonFactory.create(BuchiAcceptance.INSTANCE, this.factories.vsFactory, this.anchors, this::getSuccessor, this::getSensitiveAlphabet);
    }

    @Override
    public DegeneralizedBreakpointState createState(EquivalenceClass remainder, GObligations obligations) {
        int i;
        assert (remainder.modalOperators().stream().allMatch(SyntacticFragment.CO_SAFETY::contains));
        int length = obligations.obligations().size() + obligations.liveness().size();
        EquivalenceClass safety = obligations.safety();
        EquivalenceClass current = remainder;
        if (remainder.modalOperators().stream().allMatch(SyntacticFragment.SAFETY::contains)) {
            safety = current.and(safety);
            current = this.factories.eqFactory.getTrue();
        }
        EquivalenceClass environment = this.factories.eqFactory.conjunction(Collections3.append(obligations.liveness(), safety));
        if (length == 0) {
            return new DegeneralizedBreakpointState(0, safety, this.factory.getInitial(current, environment), EquivalenceClass.EMPTY_ARRAY, obligations);
        }
        EquivalenceClass[] nextBuilder = new EquivalenceClass[obligations.obligations().size()];
        if (current.isTrue()) {
            if (obligations.obligations().isEmpty()) {
                current = this.factory.getInitial(obligations.liveness().get(0), new EquivalenceClass[0]);
            } else {
                nextBuilder[0] = current;
                current = this.factory.getInitial(obligations.obligations().get(0), environment);
            }
        }
        int n = i = current.isTrue() ? 1 : 0;
        while (i < nextBuilder.length) {
            nextBuilder[i] = this.factory.getInitial(obligations.obligations().get(i), current);
            ++i;
        }
        int index = obligations.obligations().isEmpty() ? -obligations.liveness().size() : 0;
        return new DegeneralizedBreakpointState(index, safety, current, nextBuilder, obligations);
    }

    @Nonnull
    private BitSet getSensitiveAlphabet(DegeneralizedBreakpointState state) {
        BitSet sensitiveAlphabet = this.factory.getSensitiveAlphabet(state.current);
        sensitiveAlphabet.or(this.factory.getSensitiveAlphabet(state.safety));
        sensitiveAlphabet.or(this.factory.getSensitiveAlphabet(state.obligations.safety()));
        for (EquivalenceClass clazz : state.next) {
            sensitiveAlphabet.or(this.factory.getSensitiveAlphabet(clazz));
        }
        for (EquivalenceClass clazz : state.obligations.liveness()) {
            sensitiveAlphabet.or(this.factory.getSensitiveAlphabet(this.factory.getInitial(clazz, new EquivalenceClass[0])));
        }
        return sensitiveAlphabet;
    }

    @Nullable
    private Edge<DegeneralizedBreakpointState> getSuccessor(DegeneralizedBreakpointState state, BitSet valuation) {
        int j;
        EquivalenceClass safetySuccessor = this.factory.getSuccessor(state.safety, valuation, new EquivalenceClass[0]).and(state.obligations.safety());
        if (safetySuccessor.isFalse()) {
            return null;
        }
        EquivalenceClass currentSuccessor = this.factory.getSuccessor(state.current, valuation, safetySuccessor);
        if (currentSuccessor.isFalse()) {
            return null;
        }
        EquivalenceClass assumptions = currentSuccessor.and(safetySuccessor);
        if (assumptions.isFalse()) {
            return null;
        }
        EquivalenceClass[] nextSuccessors = this.factory.getSuccessors(state.next, valuation, assumptions);
        if (nextSuccessors == null) {
            return null;
        }
        int obligationsLength = state.obligations.obligations().size();
        int livenessLength = state.obligations.liveness().size();
        boolean acceptingEdge = false;
        boolean obtainNewGoal = false;
        if (currentSuccessor.isTrue()) {
            obtainNewGoal = true;
            j = this.scan(state.index + 1, nextSuccessors, valuation, assumptions, state.obligations);
            if (j >= obligationsLength) {
                acceptingEdge = true;
                j = this.scan(-livenessLength, nextSuccessors, valuation, assumptions, state.obligations);
                if (j >= obligationsLength) {
                    j = -livenessLength;
                }
            }
        } else {
            j = state.index;
        }
        for (int i = 0; i < nextSuccessors.length; ++i) {
            EquivalenceClass nextSuccessor = nextSuccessors[i];
            if (obtainNewGoal && i == j) {
                currentSuccessor = nextSuccessor.and(this.factory.getInitial(state.obligations.obligations().get(i), assumptions));
                assumptions = assumptions.and(currentSuccessor);
                nextSuccessors[i] = this.factories.eqFactory.getTrue();
                continue;
            }
            nextSuccessors[i] = nextSuccessor.and(this.factory.getInitial(state.obligations.obligations().get(i), assumptions));
        }
        if (obtainNewGoal && j < 0) {
            currentSuccessor = this.factory.getInitial(state.obligations.liveness().get(livenessLength + j), new EquivalenceClass[0]);
        }
        if (currentSuccessor.isFalse()) {
            return null;
        }
        for (EquivalenceClass clazz : nextSuccessors) {
            if (!clazz.isFalse()) continue;
            return null;
        }
        DegeneralizedBreakpointState successor = new DegeneralizedBreakpointState(j, safetySuccessor, currentSuccessor, nextSuccessors, state.obligations);
        return acceptingEdge ? Edge.of(successor, 0) : Edge.of(successor);
    }

    private int scan(int i, EquivalenceClass[] obligations, BitSet valuation, EquivalenceClass environment, GObligations obligations2) {
        int index = i;
        if (index < 0) {
            index = this.scanLiveness(index, valuation, environment, obligations2);
        }
        if (0 <= index) {
            index = this.scanObligations(index, obligations);
        }
        return index;
    }

    private int scanLiveness(int i, BitSet valuation, EquivalenceClass environment, GObligations obligations) {
        EquivalenceClass successor;
        int index;
        int livenessLength = obligations.liveness().size();
        for (index = i; index < 0 && (successor = this.factory.getSuccessor(this.factory.getInitial(obligations.liveness().get(livenessLength + index), new EquivalenceClass[0]), valuation, environment)).isTrue(); ++index) {
        }
        return index;
    }

    @Nonnegative
    private int scanObligations(@Nonnegative int i, EquivalenceClass[] obligations) {
        int index;
        int obligationsLength = obligations.length;
        for (index = i; index < obligationsLength && obligations[index].isTrue(); ++index) {
        }
        return index;
    }
}

