/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.rewriter;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import owl.ltl.Biconditional;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.Formula;
import owl.ltl.PropositionalFormula;
import owl.ltl.visitors.PropositionalVisitor;

public final class NormalForms {
    private static final ConjunctiveNormalFormVisitor CNF = new ConjunctiveNormalFormVisitor();
    private static final DisjunctiveNormalFormVisitor DNF = new DisjunctiveNormalFormVisitor();

    private NormalForms() {
    }

    public static Set<Set<Formula>> toCnf(Formula formula) {
        return formula.accept(CNF);
    }

    public static Formula toCnfFormula(Formula formula) {
        return formula.accept(CNF).stream().map(Disjunction::of).reduce(BooleanConstant.TRUE, Conjunction::of);
    }

    public static Set<Set<Formula>> toDnf(Formula formula) {
        return formula.accept(DNF);
    }

    public static Formula toDnfFormula(Formula formula) {
        return formula.accept(DNF).stream().map(Conjunction::of).reduce(BooleanConstant.FALSE, Disjunction::of);
    }

    private static final class DisjunctiveNormalFormVisitor
    extends PropositionalVisitor<Set<Set<Formula>>> {
        private DisjunctiveNormalFormVisitor() {
        }

        private static void minimise(Set<Set<Formula>> dnf) {
            dnf.removeIf(x -> dnf.stream().anyMatch(y -> x.size() > y.size() && x.containsAll((Collection<?>)y)));
        }

        @Override
        protected Set<Set<Formula>> modalOperatorAction(Formula formula) {
            return Set.of(Set.of(formula));
        }

        @Override
        public Set<Set<Formula>> visit(Biconditional biconditional) {
            return biconditional.nnf().accept(this);
        }

        @Override
        public Set<Set<Formula>> visit(BooleanConstant booleanConstant) {
            return booleanConstant.value ? Set.of(Set.of()) : Set.of();
        }

        @Override
        public Set<Set<Formula>> visit(Conjunction conjunction) {
            if (conjunction.children.stream().noneMatch(PropositionalFormula.class::isInstance)) {
                return Set.of(conjunction.children);
            }
            Set<Set<Formula>> dnf = Set.of(Set.of());
            for (Formula child : conjunction.children) {
                Set<Set<Formula>> childDnf = child.accept(this);
                HashSet<Set<Formula>> newDnf = new HashSet<Set<Formula>>(dnf.size() * childDnf.size());
                for (Set<Formula> clause1 : dnf) {
                    for (Set<Formula> clause2 : childDnf) {
                        newDnf.add((Set<Formula>)Sets.union(clause1, clause2).immutableCopy());
                    }
                }
                DisjunctiveNormalFormVisitor.minimise(newDnf);
                dnf = newDnf;
            }
            return dnf;
        }

        @Override
        public Set<Set<Formula>> visit(Disjunction disjunction) {
            HashSet<Set<Formula>> dnf = new HashSet<Set<Formula>>();
            disjunction.children.forEach(x -> dnf.addAll((Collection)x.accept(this)));
            DisjunctiveNormalFormVisitor.minimise(dnf);
            return dnf;
        }
    }

    private static final class ConjunctiveNormalFormVisitor
    extends PropositionalVisitor<Set<Set<Formula>>> {
        private ConjunctiveNormalFormVisitor() {
        }

        private static void minimise(Set<Set<Formula>> cnf) {
            cnf.removeIf(x -> cnf.stream().anyMatch(y -> x.size() < y.size() && y.containsAll((Collection<?>)x)));
        }

        @Override
        protected Set<Set<Formula>> modalOperatorAction(Formula formula) {
            return Set.of(Set.of(formula));
        }

        @Override
        public Set<Set<Formula>> visit(Biconditional biconditional) {
            return biconditional.nnf().accept(this);
        }

        @Override
        public Set<Set<Formula>> visit(BooleanConstant booleanConstant) {
            return booleanConstant.value ? Set.of() : Set.of(Set.of());
        }

        @Override
        public Set<Set<Formula>> visit(Conjunction conjunction) {
            HashSet<Set<Formula>> cnf = new HashSet<Set<Formula>>();
            conjunction.children.forEach(x -> cnf.addAll((Collection)x.accept(this)));
            ConjunctiveNormalFormVisitor.minimise(cnf);
            return cnf;
        }

        @Override
        public Set<Set<Formula>> visit(Disjunction disjunction) {
            if (disjunction.children.stream().noneMatch(PropositionalFormula.class::isInstance)) {
                return Set.of(disjunction.children);
            }
            Set<Set<Formula>> cnf = Set.of(Set.of());
            for (Formula child : disjunction.children) {
                Set<Set<Formula>> childCnf = child.accept(this);
                HashSet<Set<Formula>> newCnf = new HashSet<Set<Formula>>(cnf.size() * childCnf.size());
                for (Set<Formula> clause1 : cnf) {
                    for (Set<Formula> clause2 : childCnf) {
                        newCnf.add((Set<Formula>)Sets.union(clause1, clause2).immutableCopy());
                    }
                }
                ConjunctiveNormalFormVisitor.minimise(newCnf);
                cnf = newCnf;
            }
            return cnf;
        }
    }
}

