/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import java.util.BitSet;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import owl.automaton.ImplicitCachedStatesAutomaton;
import owl.automaton.LabelledEdgesAutomatonMixin;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.edge.Edge;
import owl.automaton.edge.LabelledEdge;
import owl.factories.ValuationSetFactory;

class ImplicitNonDeterministicLabelledEdgesAutomaton<S, A extends OmegaAcceptance>
extends ImplicitCachedStatesAutomaton<S, A>
implements LabelledEdgesAutomatonMixin<S, A> {
    @Nullable
    private final BiFunction<S, BitSet, ? extends Collection<Edge<S>>> edgesFunction;
    private final Function<S, ? extends Collection<LabelledEdge<S>>> labelledEdgesFunction;

    ImplicitNonDeterministicLabelledEdgesAutomaton(ValuationSetFactory factory, Collection<S> initialStates, A acceptance, @Nullable BiFunction<S, BitSet, ? extends Collection<Edge<S>>> edgesFunction, Function<S, ? extends Collection<LabelledEdge<S>>> labelledEdgesFunction) {
        super(factory, Set.copyOf(initialStates), acceptance);
        this.edgesFunction = edgesFunction;
        this.labelledEdgesFunction = labelledEdgesFunction;
    }

    @Override
    public Collection<Edge<S>> edges(S state, BitSet valuation) {
        assert (this.cache() == null || this.cache().contains(state));
        if (this.edgesFunction != null) {
            return this.edgesFunction.apply(state, valuation);
        }
        return LabelledEdgesAutomatonMixin.super.edges(state, valuation);
    }

    @Override
    public Collection<LabelledEdge<S>> labelledEdges(S state) {
        assert (this.cache() == null || this.cache().contains(state));
        return this.labelledEdgesFunction.apply(state);
    }
}

