/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.tools.docgen;

import java.io.IOException;
import java.io.InputStreamReader;
import org.onemind.commons.java.util.FileUtils;
import org.onemind.jxp.CachedJxpPage;
import org.onemind.jxp.CachingPageSource;
import org.onemind.jxp.JxpPage;
import org.onemind.jxp.JxpPageNotFoundException;
import org.onemind.jxp.JxpPageParseException;
import org.onemind.jxp.parser.AstJxpDocument;
import org.onemind.jxp.parser.JxpParser;
import org.onemind.jxp.parser.ParseException;

final class ClassPathPageSource
extends CachingPageSource {
    private final String base;
    private final ClassLoader cl;
    private final String encoding;

    ClassPathPageSource(String aBase, String anEncoding) {
        this.base = aBase;
        this.encoding = anEncoding;
        this.cl = this.getClass().getClassLoader();
    }

    protected CachedJxpPage loadJxpPage(String id) throws JxpPageNotFoundException {
        if (!this.hasJxpPage(id)) {
            throw new JxpPageNotFoundException("page " + id + " not found");
        }
        return new CachedJxpPage(this, id);
    }

    protected AstJxpDocument parseJxpDocument(JxpPage page) throws JxpPageParseException {
        try {
            JxpParser parser = this.encoding == null ? new JxpParser(this.cl.getResourceAsStream(this.getStreamName(page.getName()))) : new JxpParser(new InputStreamReader(this.cl.getResourceAsStream(this.getStreamName(page.getName())), this.encoding));
            return parser.JxpDocument();
        }
        catch (IOException ioe) {
            throw new JxpPageParseException("problem parsing page " + page.getName() + ": " + ioe.getMessage(), ioe);
        }
        catch (ParseException pe) {
            throw new JxpPageParseException("problem parsing page " + page.getName() + ": " + pe.getMessage(), pe);
        }
    }

    public boolean hasJxpPage(String id) {
        if (this.isJxpPageCached(id)) {
            return true;
        }
        return this.cl.getResource(this.getStreamName(id)) != null;
    }

    private String getStreamName(String pageName) {
        return FileUtils.concatFilePath(this.base, pageName);
    }
}

