
#include <iostream>
using std::cout;
using std::endl;

#include "exact_type.hh"



//
//  some classes
//
//////////////////////////////////////////////////////////////////////


template< class I = Bottom >
struct A : public Void< A<I> > {
};


template< class I = Bottom >
struct B1 : public A< B1<I> > {
  void m() const {
    cout << "B1::m" << endl;
  }
  void n() const {
    cout << "B1::n" << endl;
  }
};


template< class I = Bottom >
struct B2 : public A< B2<I> > {
  void m() const {
    cout << "B2::m" << endl;
  }
};



//
//  mixins
//
//////////////////////////////////////////////////////////////////////


template< template<class> class S, class I = Bottom >
struct Mixin : public S< Mixin<S,I> > {
  typedef S< Mixin<S,I> > Super;
  void m() const {
    cout << "Mixin::m" << endl;
    this->Super::m();
  }
};


template< template<class> class S, class I = Bottom >
struct SubMixin : public Mixin<S, SubMixin<S,I> > {
  typedef Mixin<S, SubMixin<S,I> > Super;
  void m() const {
    cout << "SubMixin::m" << endl;
    this->Super::m();
  }
};



//
//  foo
//
//////////////////////////////////////////////////////////////////////


template< class T >
void foo(A<T>& a) {
  to_exact(a).m();
}



//
//  main
//
//////////////////////////////////////////////////////////////////////


int main()
{
  Mixin<B1> b1;
  foo(b1);  // gives: Mixin::m
            //        B1::m

  SubMixin<B2> b2;
  foo(b2);  // gives: SubMixin::m
            //        Mixin::m
            //        B2::m
}
