#include <iostream>
using std::cout;
using std::endl;

#include "exact_type.hh"



//
//  First hierarchy
//
//////////////////////////////////////////////////////////////////////


template<class I = Bottom>
struct Base : public Void< Base<I> > {
};


template<class I = Bottom>
struct Derived : public Base< Derived<I> > {
};



//
//  Second hierarchy with contravariant methods
//
//////////////////////////////////////////////////////////////////////


template<class I = Bottom>
struct A : public Void< A<I> > {
  template<class T>
  void m(Derived<T>& d) {
    to_exact(this)->m(d);
  }
};


template<class I = Bottom>
struct B1 : public A< B1<I> > {
  template<class T>
  void m(Base<T>& b) {
    cout << "A1::m" << endl;
  }
};




//
//  foo
//
//////////////////////////////////////////////////////////////////////


template<class T>
void foo(A<T>& a) {
  Derived<> d;
  a.m(d);
}



//
//  main
//
//////////////////////////////////////////////////////////////////////


int main()
{
  A1<> a1;
  foo(a1);
}
