/*
 *  file op.hh
 *
 *  Copyright (C) 1999 EPITA-LRDE
 *  EPITA Research and Development Laboratory
 *  lrde@epita.fr
 */

#ifndef OP_HH
#define OP_HH

#include "get.hh"
#include "pred.hh"


template< typename O, 
          template< class U > class get_A = get_value,
          typename P = Pred_true >
struct op
{
  template< typename I >
  static void on( I& input, 
                  const typename get_A< typename I::value_type >::output_type&  cst, 
                  P  pred  =  P() )
    {
      O  oper;
      get_A< typename I::value_type >  access;
      typename I::iterator_type  iter( input );
      for ( iter.first(); ! iter.isDone(); iter.next() )
          if ( pred( access( iter() ) ) )
            oper( access( iter() ), cst );
    }
};



#endif
